#include "g_local.h"
#include "g_playmidi.h"
#include <io.h>
#include <FCNTL.H>
#include "g_xtrasound.h"



char NewSounds [NUM_SOUNDS][50];
int XtraSound = 0;


void LoadSounds()
{
	int file, i;
	char file_name[256];
	cvar_t *game_dir;
	
	game_dir = gi.cvar ("game", "", 0);
	sprintf(file_name,".\\%s\\sound.txt",game_dir->string);

	file = _open(file_name,_O_RDONLY | _O_TEXT);
	XtraSound = 0;

	if (file != -1)
	{
		long file_size;
		char *p_buffer;
		char *p_name;
		long counter = 0;
		int n_chars = 0;


		i =0;
		file_size = _filelength(file);
		p_buffer = malloc(file_size);
		memset(p_buffer,0,file_size);

		file_size = _read(file, (void *)p_buffer, file_size);

		gi.dprintf("Reading from sound.txt.");

		p_name = p_buffer;
		do
		{
			while (*p_name != '\r' && *p_name != '\n' && counter < file_size)
			{
				n_chars++;
				counter++;
				p_name++;
			}
			if (n_chars)
			{
				memcpy(&NewSounds[i][0], p_name - n_chars, n_chars);
				memset(&NewSounds[i][n_chars], 0, 1);
				i++;
				n_chars = 0;
			}
			counter++;
			p_name++;

		} while (counter < file_size);

		free(p_buffer);
		_close(file);

		if (i)
		{
			XtraSound = true;
			
		}
	}
}

